<?php
$html = '
<html>
<head></head>
<body>
<!--mpdf
<htmlpageheader name="myheader">
<table width="100%"><tr>
<td width="50%"><img src="../uploads/admin/img/'. $logo. '" height="150px"/></td>
<td width="50%" style="text-align: right;"><h1>'.$this->lang->line('quotes_quote').'</h1><br /><span style="font-weight: bold; font-size: 12pt;">' . $quote_number.'</span></td>
</tr></table>
</htmlpageheader>
<htmlpagefooter name="myfooter">
<div style="border-top: 1px solid #000000; font-size: 9pt; text-align: center; padding-top: 3mm; ">
Page {PAGENO} of {nb}
</div>
</htmlpagefooter>
<sethtmlpageheader name="myheader" value="on" show-this-page="1" />
<sethtmlpagefooter name="myfooter" value="on" />
mpdf-->
<div style="text-align: right"><span class="bordercolor">'. $this->lang->line('issued_date'). '</span>: '. $date. '</div>
<div style="text-align: right"><span class="bordercolor">'. $this->lang->line('due_date'). '</span>: '. $due_date. '</div>
<table width="100%" style="font-family: serif;" cellpadding="10"><tr>
<td width="45%" style="border-top: solid 0.1px #90b041;"><span style="font-size: 7pt; color: #555555; font-family: sans;">'.strtoupper($this->lang->line('label_payment_to')).':</span><br /><br /><strong>'.trim($user_company).'</strong>';
if ($user_address)
{
    if ($user_address["user_address1"])
    {
        $html .= '<br />'.trim($user_address["user_address1"]);
    }
    if($user_address["user_address2"])
    {
        $html .= ' '. trim($user_address["user_address2"]);
    }
    if($user_address["user_postcode"])
    {
        $html .= '<br />'. trim($user_address["user_postcode"]);
    }
    if($user_address["user_city"])
    {
        $html .= ' '. trim($user_address["user_city"]);
    }
    if($user_address["user_state"])
    {
        $html .= ' '. trim($user_address["user_state"]);
    }
    if($user_address["user_country"])
    {
        $html .= ' '. trim($user_address["user_country"]);
    }
}
if($tax_id)
{
    $html .= '<br />'.$this->lang->line('label_tax_number'). ': ' .trim($tax_id);
}
if($chamber_commerce_id)
{
    $html .= '<br />'.$this->lang->line('label_short_chamber_commerce'). ': ' .trim($chamber_commerce_id);
}
if($bank_number)
{
    $html .= '<br />'.$this->lang->line('label_bank_number') .': ' .trim($bank_number);
}
if($bank_name)
{
    $html .= '<br />'.$this->lang->line('label_bank') .': ' .trim($bank_name);
}
$html .= '</td><td width="10%">&nbsp;</td><td width="45%" style="border-top: solid 0.1px #90b041;"><span style="font-size: 7pt; color: #555555; font-family: sans;">'. strtoupper($this->lang->line('label_invoiced_to')).':</span><br /><br />';
if ($client) 
{
    $html .= '<strong>'.$client["name_company"].'</strong>';
    if ($client['address1']) 
    {
        $html .= '<br />'.trim($client["address1"]);
    }
    if($client["address2"])
    {
        $html .= '<br />'. trim($client["address2"]);
    }
    if($client["postcode"])
    {
        $html .= '<br />'. trim($client["postcode"]);
    }
    if($client["city"])
    {
        $html .= ' '. trim($client["city"]);
    }
    if($client["state"])
    {
        $html .= ' '. trim($client["state"]);
    }
    if($client["country"])
    {
        $html .= ' '. trim($client["country"]);
    }
    if($client["client_tax_number"])
    {
        $html .= '<br />'.$this->lang->line('label_tax_number'). ': ' .trim($client["client_tax_number"]);
    }
    if($client["client_chamber_com"])
    {
        $html .= '<br />'.$this->lang->line('label_short_chamber_commerce'). ': ' .trim($client["client_chamber_com"]);
    }
    if($client["client_bank_number"])
    {
        $html .= '<br />'.$this->lang->line('label_bank_number'). ': ' .trim($client["client_bank_number"]);
    }
    if($client["client_bank_name"])
    {
        $html .= '<br />'.$this->lang->line('label_bank'). ': ' .trim($client["client_bank_name"]);
    }
}
$html .= '</td>
</tr></table>
<br />
<table class="items" width="100%" style="font-size: 10pt; border-collapse: collapse;border-top: solid #8ab144;" cellpadding="9">
<thead>
<tr>
<td>#</td>
<td>'.$this->lang->line('th_item').'</td>
<td>'.$this->lang->line('label_unity_of_measure_short').'</td>
<td>'.$this->lang->line('quantity').'</td>
<td>'.$this->lang->line('th_price').'</td>
<td>'.$this->lang->line('th_line_total').'</td>
<td align="center">'.$this->lang->line('label_tax_total_amount').'</td>
</tr>
</thead>
<tbody>
<!-- ITEMS HERE -->';
foreach ($invoiceitems as $k => $item) {
    $k += 1;
    $tax_value = format_number( $item->item_subtotal * $item->item_tax_rate / 100 );
    $total_tax += $tax_value;
    $grand_total = format_number( $total + $total_tax );
$html .= '<tr>
<td align="left">'.$k.'</td>
<td>'.$item->item_name.' ['. $item->item_sku. ']</td>
<td align="center">'.$item->item_uom.'</td>
<td align="left">'.$item->item_quantity.'</td>
<td class="cost">'.add_currency( format_number($item->item_price * $change_rate), $client_id ).'</td>
<td class="cost">'.add_currency( format_number($item->item_subtotal * $change_rate), $client_id ).'</td>
<td class="cost">'.add_currency( format_number( $tax_value * $change_rate ), $client_id ).'<br /></td>
</tr>';
}
$html .= '<!-- END ITEMS HERE -->
<tr>
<td class="blanktotal" colspan="5" rowspan="9"></td>
<td class="totals">'.ucfirst( $this->lang->line('label_subtotal') ).'</td>
<td class="totals cost">'.add_currency( format_number( $subtotal * $change_rate ), $client_id ).'</td>
</tr>';
$html .= '<tr>
    <td class="totals">'.ucfirst( $this->lang->line('label_tax') ).'</td>
    <td class="totals cost">'.add_currency( format_number( $total_tax * $change_rate ), $client_id ).'</td>
    </tr>';
$html .='
    <tr>
    <td class="totals"><b>'.strtoupper( $this->lang->line( 'label_grand_total' ) ).'</b></td>
    <td class="totals cost"><b>'.add_currency( format_number( ($subtotal + $total_tax) * $change_rate), $client_id ).'</b></td>
    </tr>
</tbody>
</table>
<div style="text-align: left; color: #82b53f"><br />'.$this->lang->line('invoice_transactions').'<hr style="text-align:left; color:#82b53f width:100%"></div>';

$html .= '<table width="100%" bgcolor="#ccc" cellspacing="1" cellpadding="2" border="0">
    <tr height="30" bgcolor="#efefef" style="font-weight:bold;text-align:center;">
        <td width="25%" align="center">' . $this->lang->line('transaction_date') . '</td>
        <td width="25%" align="center">' . $this->lang->line('transaction_gateway') . '</td>
        <td width="30%" align="center">' . $this->lang->line('label_transaction_id') . '</td>
        <td width="20%" align="center">' . $this->lang->line('transaction_amount') . '</td>
    </tr>';

if (!count($transactions) OR !$transactions) {
    $html .= '
    <tr bgcolor="#fff">
        <td colspan="4" align="center">' . $this->lang->line('transaction_not_found') . '</td>
    </tr>';
} else {
    foreach ($transactions AS $trans) {
        $html .= '
        <tr bgcolor="#fff">
            <td align="center">' . $trans['date'] . '</td>
            <td align="center">' . $trans['gateway'] . '</td>
            <td align="center">' . $trans['transid'] . '</td>
            <td align="center">' . add_currency( format_number($trans['amount'] * $change_rate ), $client_id ). '</td>
        </tr>';
    }
}
if($transactions) {
    $html .= '
    <tr nobr="true" height="30" bgcolor="#efefef" style="font-weight:bold;">
        <td colspan="3" align="right"><strong>' . $this->lang->line('invoice_balance') . '</strong></td>
        <td align="center"><strong>' . add_currency( format_number($balance, $client_id) ) . '</strong></td>
    </tr>';

}
$html .='
</table>';
$html .='<br/>
<table width="100%">
<tr>
<td width="50%" align="left"><span style="font-size: 9pt; color: #555555; font-family: sans;">'.strtoupper( $this->lang->line( 'seller_stamp_signature' ) ).'</span></td>
<td width="50%" align="right"><span style="font-size: 9pt; color: #555555; font-family: sans;">'.strtoupper( $this->lang->line( 'client_stamp_signature' ) ).'</td>
</tr>
</table><br /><br /><br /><br />
';
# Notes
if ($notes) {
    $html .= $this->lang->line('notes') . ': ' . $notes;
}
if( $terms && _has_option('display_terms') )
{
    $html .= '<br />' .$terms;
}

$html .='
</body>
</html>';

//==============================================================
//==============================================================
//==============================================================
//==============================================================
//==============================================================
//==============================================================

require_once(APPPATH . 'third_party/Mpdf60/mpdf.php');

$mpdf=new mPDF('c','A4','','',20,15,48,25,10,10); 
$mpdf->SetProtection(array('print'));
$mpdf->SetTitle($invoice_title);
$mpdf->SetWatermarkText($status);
$mpdf->watermark_font = 'DejaVuSansCondensed';
$mpdf->watermarkTextAlpha = 0.1;
$mpdf->SetDisplayMode('fullpage');

// LOAD a stylesheet
$stylesheet = file_get_contents('oc_contents/theme/css/pdf.css');
$mpdf->WriteHTML($stylesheet,1); // The parameter 1 tells that this is css/style only and no body/html/text
$mpdf->WriteHTML($html);

$mpdf->Output(FCPATH.'uploads/pdf/quotes/'.$non_formatted_quote_number.'.pdf', 'F');
$mpdf->Output($quote_title.'-'.$client["name_company"].'.pdf', 'I');exit;